#!/bin/sh

_SAMPLE_DIR_=`dirname "$0"`
YD="$_SAMPLE_DIR_/../.."

if [ `uname` = "Darwin" ] ; then
  JAVA_EXE="$YD/../jdk/Contents/Home/bin/java"
elif [ "`uname | grep Linux`" ] ; then
  if [ "`uname -m | grep x86_64`" ] || [ "`uname -m | grep aarch64`" ] || [ "`uname -m | grep arm64`" ] ; then
    if [ "`getconf LONG_BIT | grep 64`" ] ; then
      JAVA_EXE="$YD/jre64/bin/java"
    fi
  fi
fi

if [ ! -r "$JAVA_EXE" ] && [ ! -z "$JAVA_HOME" ] ; then
  JAVA_EXE="$JAVA_HOME/bin/java"
fi

if [ ! -r "$JAVA_EXE" ] ; then
  JAVA_EXE=java
fi

# Set AGENT_PATH to system-dependent path to the profiler agent library
AGENT_PATH=""
if [ "`uname | grep Linux`" ] ; then
  if [ "`uname -m | grep arm`" ] ; then
    AGENT_PATH="$YD/bin/linux-arm-32/libyjpagent.so"
  elif [ "`uname -m | grep aarch64`" ] ; then
    AGENT_PATH="$YD/bin/linux-arm-64/libyjpagent.so"
  elif [ "`uname -m | grep ppc64le`" ] ; then
    AGENT_PATH="$YD/bin/linux-ppc-64le/libyjpagent.so"
  elif [ "`uname -m | grep 86`" ] ; then
    # Intel
    if [ "`$JAVA_EXE -version 2>&1 | grep 64-Bit`" ] ; then
      AGENT_PATH="$YD/bin/linux-x86-64/libyjpagent.so"
    else
      AGENT_PATH="$YD/bin/linux-x86-32/libyjpagent.so"
    fi
  fi
elif [ `uname` = 'Darwin' ] ; then
  AGENT_PATH="$YD/bin/mac/libyjpagent.dylib"
fi

if [ -z "$AGENT_PATH" ] ; then
  echo "Unsupported platform: `uname -a`"
  exit
fi

echo "Using Java: $JAVA_EXE"
echo "Using agent: $AGENT_PATH"

exec "$JAVA_EXE" "-agentpath:$AGENT_PATH" -classpath "$YD/lib/yourkit.jar:$_SAMPLE_DIR_/classes" ApiDemo2
