/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.attach;

import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.spi.AttachProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import sun.tools.attach.HotSpotVirtualMachine;

public class WindowsVirtualMachine
extends HotSpotVirtualMachine {
    private static byte[] stub;
    private volatile long hProcess;

    WindowsVirtualMachine(AttachProvider attachProvider, String string) throws AttachNotSupportedException, IOException {
        super(attachProvider, string);
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new AttachNotSupportedException("Invalid process identifier");
        }
        this.hProcess = WindowsVirtualMachine.openProcess(n);
        try {
            WindowsVirtualMachine.enqueue(this.hProcess, stub, null, null, new Object[0]);
        }
        catch (IOException iOException) {
            throw new AttachNotSupportedException(iOException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach() throws IOException {
        WindowsVirtualMachine windowsVirtualMachine = this;
        synchronized (windowsVirtualMachine) {
            if (this.hProcess != -1L) {
                WindowsVirtualMachine.closeProcess(this.hProcess);
                this.hProcess = -1L;
            }
        }
    }

    InputStream execute(String string, Object ... objectArray) throws AgentLoadException, IOException {
        assert (objectArray.length <= 3);
        int n = new Random().nextInt();
        String string2 = "\\\\.\\pipe\\javatool" + n;
        long l = WindowsVirtualMachine.createPipe(string2);
        if (this.hProcess == -1L) {
            WindowsVirtualMachine.closePipe(l);
            throw new IOException("Detached from target VM");
        }
        try {
            WindowsVirtualMachine.enqueue(this.hProcess, stub, string, string2, objectArray);
            WindowsVirtualMachine.connectPipe(l);
            PipedInputStream pipedInputStream = new PipedInputStream(l);
            int n2 = this.readInt(pipedInputStream);
            if (n2 != 0) {
                if (string.equals("load")) {
                    throw new AgentLoadException("Failed to load agent library");
                }
                throw new IOException("Command failed in target VM");
            }
            return pipedInputStream;
        }
        catch (IOException iOException) {
            WindowsVirtualMachine.closePipe(l);
            throw iOException;
        }
    }

    static native void init();

    static native byte[] generateStub();

    static native long openProcess(int var0) throws IOException;

    static native void closeProcess(long var0) throws IOException;

    static native long createPipe(String var0) throws IOException;

    static native void closePipe(long var0) throws IOException;

    static native void connectPipe(long var0) throws IOException;

    static native int readPipe(long var0, byte[] var2, int var3, int var4) throws IOException;

    static native void enqueue(long var0, byte[] var2, String var3, String var4, Object ... var5) throws IOException;

    static {
        System.loadLibrary("attach");
        WindowsVirtualMachine.init();
        stub = WindowsVirtualMachine.generateStub();
    }

    private class PipedInputStream
    extends InputStream {
        private long hPipe;

        public PipedInputStream(long l) {
            this.hPipe = l;
        }

        public synchronized int read() throws IOException {
            byte[] byArray = new byte[1];
            int n = this.read(byArray, 0, 1);
            if (n == 1) {
                return byArray[0] & 0xFF;
            }
            return -1;
        }

        public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
            if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            return WindowsVirtualMachine.readPipe(this.hPipe, byArray, n, n2);
        }

        public void close() throws IOException {
            if (this.hPipe != -1L) {
                WindowsVirtualMachine.closePipe(this.hPipe);
                this.hPipe = -1L;
            }
        }
    }
}

