/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.probes;

import com.yourkit.asserts.Asserts;
import com.yourkit.asserts.NotNull;
import com.yourkit.asserts.Nullable;
import com.yourkit.probes.FailedEventPolicy;
import com.yourkit.probes.ObjectRowIndexMap;
import com.yourkit.probes.ObjectSet;
import com.yourkit.probes.ResourceTable;
import com.yourkit.probes.Table;
import com.yourkit.runtime.Callback;

public abstract class ResourceRegistry<T, P> {
    @NotNull
    private final ObjectRowIndexMap<T> myResource2Row;
    @NotNull
    private final ObjectSet<T> myClosedResources;
    @Nullable
    private final ResourceRegistry<P, ?> myParent;
    private final ResourceTable<T> myResourceTable;
    private final Table myOpenTable;
    private final Table myCloseTable;
    @NotNull
    final Class<?> myProbeClass;

    protected ResourceRegistry(@NotNull Class<?> probeClass, @Nullable ResourceRegistry<P, ?> parent, @NotNull String resourceTableName, @Nullable String resourceIdentifierColumnName) {
        if (probeClass == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (resourceTableName == null) {
            throw new IllegalArgumentException("Parameter 3 must not be null");
        }
        this.myResource2Row = new ObjectRowIndexMap();
        this.myClosedResources = new ObjectSet();
        this.myProbeClass = probeClass;
        this.myParent = parent;
        this.myResourceTable = parent != null ? new ResourceTable(parent.myResourceTable, resourceTableName, resourceIdentifierColumnName) : new ResourceTable(probeClass, resourceTableName, resourceIdentifierColumnName);
        this.myOpenTable = new Table(this.myResourceTable, "Open", 161L){};
        this.myCloseTable = new Table(this.myResourceTable, "Close", 161L){};
    }

    protected final long openOnEnterImpl() {
        int resourceRow = this.myResourceTable.createRow();
        if (Table.shouldIgnoreRow(resourceRow)) {
            return 0L;
        }
        int openRow = this.myOpenTable.createRow();
        if (Table.shouldIgnoreRow(openRow)) {
            this.myResourceTable.deleteRow(resourceRow);
            return 0L;
        }
        return ResourceRegistry.composeResourceID(openRow, resourceRow);
    }

    /*
     * WARNING - void declaration
     */
    protected int openOnExitImpl(long resourceID, @Nullable String resourceName, @Nullable T resource, @Nullable P parentResource, @Nullable Throwable exception, @NotNull FailedEventPolicy failedEventPolicy) {
        void policy;
        if (failedEventPolicy == null) {
            throw new IllegalArgumentException("Parameter 6 must not be null");
        }
        if (parentResource == null != (this.myParent == null)) {
            Asserts.fail();
        }
        int openRow = ResourceRegistry.getOpenRow(resourceID);
        int resourceRow = ResourceRegistry.getResourceRow(resourceID);
        if (resource == null) {
            this.myOpenTable.deleteRow(openRow);
            this.myResourceTable.deleteRow(resourceRow);
            return 0;
        }
        if (Table.shouldIgnoreRow(resourceRow)) {
            return 0;
        }
        if (!this.myResource2Row.putFirst(resource, resourceRow)) {
            this.myOpenTable.deleteRow(openRow);
            this.myResourceTable.deleteRow(resourceRow);
            return 0;
        }
        if (exception != null) {
            this.myClosedResources.add(resource);
        }
        if (exception != null && policy == FailedEventPolicy.DISCARD) {
            this.myOpenTable.deleteRow(openRow);
            this.myResourceTable.deleteRow(resourceRow);
            return 0;
        }
        if (this.myParent != null) {
            int parentResourceRow = this.myParent.getOrCreate(parentResource);
            if (parentResourceRow == 0) {
                Callback.warningToLogFile((String)("cannot get row:\n  resource: " + resource + "\n  parent resource: " + parentResource));
                this.myOpenTable.deleteRow(openRow);
                this.myResourceTable.deleteRow(resourceRow);
                return 0;
            }
            this.myResourceTable.myFKColumn.setValue(resourceRow, parentResourceRow);
        }
        this.myResourceTable.setResourceObject(resourceRow, resource);
        if (this.myResourceTable.hasResourceName()) {
            this.myResourceTable.setResourceName(resourceRow, this.getResourceName(resourceName, resource));
        }
        this.myOpenTable.myFKColumn.setValue(openRow, resourceRow);
        this.myOpenTable.closeRow(openRow, exception);
        return resourceRow;
    }

    public int closeOnEnter(@NotNull T resource) {
        if (resource == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        int closeRow = this.myCloseTable.createRow();
        if (Table.shouldIgnoreRow(closeRow)) {
            return 0;
        }
        if (!this.myClosedResources.addFirst(resource)) {
            this.myCloseTable.deleteRow(closeRow);
            return 0;
        }
        int resourceRow = this.getOrCreate(resource);
        if (Table.shouldIgnoreRow(resourceRow)) {
            this.myCloseTable.deleteRow(closeRow);
            return 0;
        }
        this.myCloseTable.myFKColumn.setValue(closeRow, resourceRow);
        return closeRow;
    }

    public void closeOnExit(int rowIndex, @Nullable Throwable exception) {
        this.myCloseTable.closeRow(rowIndex, exception);
    }

    public void setOpenException(int rowIndex, @Nullable Throwable exception) {
        this.myOpenTable.setEventTableRowException(rowIndex, exception);
    }

    @NotNull
    public ResourceTable<T> getResourceTable() {
        ResourceTable<T> resourceTable = this.myResourceTable;
        if (resourceTable == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return resourceTable;
    }

    @Nullable
    protected P retrieveParent(@NotNull T resource) {
        if (resource == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return null;
    }

    public int get(T resource) {
        return this.myResource2Row.get(resource);
    }

    public int getOrCreate(T resource) {
        int resourceID = this.myResource2Row.get(resource);
        if (resourceID != 0) {
            return resourceID;
        }
        P parent = null;
        if (this.myParent != null) {
            try {
                parent = this.retrieveParent(resource);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (parent == null) {
                return 0;
            }
            this.myParent.getOrCreate(parent);
        }
        int resourceRow = this.myResourceTable.createRow();
        return this.openOnExitImpl(ResourceRegistry.composeResourceID(0, resourceRow), null, resource, parent, null, FailedEventPolicy.DISCARD);
    }

    @Nullable
    private String getResourceName(@Nullable String knownName, @NotNull T resource) {
        if (resource == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (knownName != null) {
            return knownName;
        }
        String retrievedName = null;
        try {
            retrievedName = this.retrieveResourceName(resource);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retrievedName;
    }

    @Nullable
    protected String retrieveResourceName(@NotNull T resource) {
        if (resource == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return null;
    }

    public void mapAlias(@Nullable T resource, @Nullable T alias) {
        if (resource == null || alias == null) {
            return;
        }
        int rowIndex = this.getOrCreate(resource);
        if (Table.shouldIgnoreRow(rowIndex)) {
            return;
        }
        this.myResource2Row.putFirst(alias, rowIndex);
    }

    private static long composeResourceID(int openRow, int resourceRow) {
        return (long)openRow & 0xFFFFFFFFL | (long)resourceRow << 32;
    }

    public static int getOpenRow(long resourceID) {
        return (int)resourceID;
    }

    private static int getResourceRow(long resourceID) {
        return (int)(resourceID >> 32);
    }
}

