/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.probes;

import com.yourkit.asserts.NotNull;
import com.yourkit.probes.Table;
import com.yourkit.runtime.Callback;

public final class ObjectRowIndexMap<Key> {
    private final long myMapID = Callback.createObjectMap();

    protected void finalize() throws Throwable {
        super.finalize();
        Callback.deleteObjectMap((long)this.myMapID);
    }

    public int put(@NotNull Key key, int value) {
        if (key == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return Callback.objectMapPut((long)this.myMapID, key, (int)value, (boolean)false, (int)0);
    }

    public boolean putAtomic(@NotNull Key key, int newValue, int expectedValue) {
        if (key == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return Callback.objectMapPut((long)this.myMapID, key, (int)newValue, (boolean)true, (int)expectedValue) == expectedValue;
    }

    public boolean putFirst(@NotNull Key key, int newValue) {
        if (key == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return this.putAtomic(key, newValue, 0);
    }

    public int get(@NotNull Key key) {
        if (key == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return Callback.objectMapGet((long)this.myMapID, key);
    }

    public boolean containsKey(@NotNull Key key) {
        if (key == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return !Table.shouldIgnoreRow(this.get(key));
    }

    public int remove(@NotNull Key key) {
        if (key == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return this.put(key, 0);
    }
}

