/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.probes;

import com.yourkit.asserts.NotNull;
import com.yourkit.asserts.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class Counter {
    @NotNull
    private static final AtomicInteger ourNextGuidCounter = new AtomicInteger();
    @NotNull
    private final String myGuid;
    @NotNull
    private final String[] myPath;
    @NotNull
    private final ArrayList<String> myTags;

    public Counter(@Nullable String guid, String ... path) {
        if (path == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        this.myTags = new ArrayList();
        this.myGuid = guid != null ? guid : this.generateCounterGuid();
        this.myPath = path;
    }

    @NotNull
    public final String[] getPath() {
        if (this.myPath == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return this.myPath;
    }

    @NotNull
    public final String getGuid() {
        String string = this.myGuid;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    abstract void setValueAndResetMinMax(int var1);

    @NotNull
    private String generateCounterGuid() {
        String string = "yourkit.counter.guid." + ourNextGuidCounter.incrementAndGet();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    final Counter addTags(String ... tags) {
        if (tags == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myTags.addAll(Arrays.asList(tags));
        Counter counter = this;
        if (counter == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return counter;
    }

    @NotNull
    final String[] getTags() {
        String[] stringArray = this.myTags.toArray(new String[0]);
        if (stringArray == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return stringArray;
    }
}

