/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.probes;

import com.yourkit.asserts.NotNull;
import com.yourkit.asserts.Nullable;
import com.yourkit.probes.Counter;
import com.yourkit.runtime.Callback;
import java.time.Duration;

public abstract class CallCounter
extends Counter {
    @NotNull
    private Duration mySumDuration;
    private long myMaxDurationNs;
    @Nullable
    private String myMaxCallDetail;
    private long myCount;

    public CallCounter(@Nullable String guid, String ... path) {
        if (path == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        super(guid, path);
        this.mySumDuration = Duration.ZERO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setValueAndResetMinMax(int definitionId) {
        String maxCallDetail;
        long count;
        long maxDurationNs;
        Duration sumDuration;
        CallCounter callCounter = this;
        synchronized (callCounter) {
            sumDuration = this.mySumDuration;
            maxDurationNs = this.myMaxDurationNs;
            count = this.myCount;
            maxCallDetail = this.myMaxCallDetail;
            this.myMaxCallDetail = null;
            this.myMaxDurationNs = 0L;
        }
        Callback.setCallCounterValue((int)definitionId, (String)maxCallDetail, (long)count, (long)maxDurationNs, (int)sumDuration.getNano(), (long)sumDuration.getSeconds());
    }

    public final void updateMs(long durationMs, @Nullable Object callDescriptionObject) {
        this.updateNs(durationMs * 1000000L, callDescriptionObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateNs(long durationNs, @Nullable Object callDescriptionObject) {
        if (Callback.shouldSkipThread()) {
            return;
        }
        durationNs = Math.max(0L, durationNs);
        CallCounter callCounter = this;
        synchronized (callCounter) {
            this.mySumDuration = this.mySumDuration.plusNanos(durationNs);
            if (this.myMaxDurationNs < durationNs) {
                this.myMaxDurationNs = durationNs;
                this.myMaxCallDetail = callDescriptionObject != null ? this.getDetail(callDescriptionObject) : null;
            }
            ++this.myCount;
        }
    }

    @Nullable
    public abstract String getDetail(@NotNull Object var1);
}

