/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.SerializedName;
import com.yourkit.asserts.Asserts;
import com.yourkit.asserts.NotNull;
import com.yourkit.asserts.Nullable;
import java.io.Reader;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class GsonUtil {
    @NotNull
    public static final Gson GSON = GsonUtil.newPrettyBuilder().excludeFieldsWithoutExposeAnnotation().create();

    @NotNull
    public static GsonBuilder newPrettyBuilder() {
        GsonBuilder gsonBuilder = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting();
        if (gsonBuilder == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return gsonBuilder;
    }

    public static int getIntProperty(@NotNull JsonObject obj, @NotNull String propertyName, int defaultValue) {
        if (obj == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        JsonElement element = obj.get(propertyName);
        return element == null || element.isJsonNull() ? defaultValue : element.getAsInt();
    }

    public static long getLongProperty(@NotNull JsonObject obj, @NotNull String propertyName, long defaultValue) {
        if (obj == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        JsonElement element = obj.get(propertyName);
        return element == null || element.isJsonNull() ? defaultValue : element.getAsLong();
    }

    @Nullable
    public static String getStringProperty(@NotNull JsonObject obj, @NotNull String propertyName) {
        if (obj == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        JsonElement element = obj.get(propertyName);
        return element == null || element.isJsonNull() ? null : element.getAsString();
    }

    @NotNull
    public static String getStringPropertyNotNull(@NotNull JsonObject obj, @NotNull String propertyName) {
        if (obj == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        String result = GsonUtil.getStringProperty(obj, propertyName);
        if (result == null) {
            Asserts.fail();
        }
        String string = result;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static <CollectionType extends List<?>, ElementType> List<ElementType> deserializeList(@NotNull Gson gson, @NotNull String jsonStr, @NotNull Class<CollectionType> collectionType, @NotNull Class<ElementType> elementType) {
        if (gson == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (jsonStr == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (collectionType == null) {
            throw new IllegalArgumentException("Parameter 3 must not be null");
        }
        if (elementType == null) {
            throw new IllegalArgumentException("Parameter 4 must not be null");
        }
        List list = (List)gson.fromJson(jsonStr, new CollectionOfSomething<CollectionType, ElementType>(collectionType, elementType));
        if (list == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return list;
    }

    @NotNull
    public static <KeyType, ValueType> Map<KeyType, ValueType> deserializeMap(@NotNull Gson gson, @NotNull String jsonStr, @NotNull Class<KeyType> keyClass, @NotNull Class<ValueType> valueClass) {
        if (gson == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (jsonStr == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (keyClass == null) {
            throw new IllegalArgumentException("Parameter 3 must not be null");
        }
        if (valueClass == null) {
            throw new IllegalArgumentException("Parameter 4 must not be null");
        }
        Map map = (Map)gson.fromJson(jsonStr, (Type)new MapOfSomething(keyClass, valueClass));
        if (map == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return map;
    }

    @NotNull
    public static <KeyType, ValueType> Map<KeyType, ValueType> deserializeMap(@NotNull Gson gson, @NotNull JsonElement element, @NotNull Class<KeyType> keyClass, @NotNull Class<ValueType> valueClass) {
        if (gson == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (keyClass == null) {
            throw new IllegalArgumentException("Parameter 3 must not be null");
        }
        if (valueClass == null) {
            throw new IllegalArgumentException("Parameter 4 must not be null");
        }
        Map map = (Map)gson.fromJson(element, (Type)new MapOfSomething(keyClass, valueClass));
        if (map == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return map;
    }

    @NotNull
    public static <KeyType, ValueType> Map<KeyType, ValueType> deserializeMap(@NotNull Gson gson, @NotNull Reader reader, @NotNull Class<KeyType> keyClass, @NotNull Class<ValueType> valueClass) {
        if (gson == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (reader == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (keyClass == null) {
            throw new IllegalArgumentException("Parameter 3 must not be null");
        }
        if (valueClass == null) {
            throw new IllegalArgumentException("Parameter 4 must not be null");
        }
        Map map = (Map)gson.fromJson(reader, (Type)new MapOfSomething(keyClass, valueClass));
        if (map == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return map;
    }

    @NotNull
    public static <CollectionType extends Set<?>, ElementType> Set<ElementType> deserializeSet(@NotNull Gson gson, @NotNull String jsonStr, @NotNull Class<CollectionType> collectionType, @NotNull Class<ElementType> elementType) {
        if (gson == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (jsonStr == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (collectionType == null) {
            throw new IllegalArgumentException("Parameter 3 must not be null");
        }
        if (elementType == null) {
            throw new IllegalArgumentException("Parameter 4 must not be null");
        }
        Set set = (Set)gson.fromJson(jsonStr, new CollectionOfSomething<CollectionType, ElementType>(collectionType, elementType));
        if (set == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return set;
    }

    @NotNull
    public static <K extends Enum<?>> String serializeEnum(@NotNull K value) {
        if (value == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String serializedName = GsonUtil.getSerializedName(value);
        String string = serializedName != null ? serializedName : value.name();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static <K extends Enum<?>, T extends Class<? extends K>> K deserializeEnum(@NotNull String value, @NotNull T type) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        K val = GsonUtil.deserializeEnumNullable(value, type);
        if (val == null) {
            throw new IllegalArgumentException("Cannot deserialize value=" + value);
        }
        K k = val;
        if (k == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return k;
    }

    @NotNull
    public static <K extends Enum<?>, T extends Class<? extends K>> K deserializeEnum(@Nullable String value, @NotNull T type, @NotNull K defaultValue) {
        if (type == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException("Parameter 3 must not be null");
        }
        K val = GsonUtil.deserializeEnumNullable(value, type);
        K k = val != null ? val : defaultValue;
        if (k == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return k;
    }

    @Nullable
    public static <K extends Enum<?>, T extends Class<? extends K>> K deserializeEnumNullable(@Nullable String value, @NotNull T type) {
        Enum[] constants;
        if (type == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (value == null) {
            return null;
        }
        for (Enum constant : constants = (Enum[])type.getEnumConstants()) {
            String _serializedName = GsonUtil.getSerializedName(constant);
            if (!(_serializedName != null ? Objects.equals(_serializedName, value) : Objects.equals(constant.name(), value))) continue;
            return (K)constant;
        }
        return null;
    }

    @Nullable
    public static <T extends Enum<?>> String getSerializedName(@NotNull T constant) {
        if (constant == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        try {
            Field field = constant.getClass().getField(constant.name());
            SerializedName annotation = field.getAnnotation(SerializedName.class);
            return annotation != null ? annotation.value() : null;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static JsonElement wrapYamlObject(@Nullable Object o) {
        JsonElement jsonElement;
        if (o == null) {
            jsonElement = JsonNull.INSTANCE;
            if (jsonElement == null) throw new IllegalStateException("Method must not return null");
            return jsonElement;
        }
        if (o instanceof Collection) {
            Collection collection = (Collection)o;
            JsonArray array = new JsonArray();
            for (Object childObj : collection) {
                array.add(GsonUtil.wrapYamlObject(childObj));
            }
            jsonElement = array;
            if (jsonElement == null) throw new IllegalStateException("Method must not return null");
            return jsonElement;
        }
        if (o.getClass().isArray()) {
            JsonArray array = new JsonArray();
            int length = Array.getLength(array);
            for (int i = 0; i < length; ++i) {
                array.add(GsonUtil.wrapYamlObject(Array.get(array, i)));
            }
            jsonElement = array;
            if (jsonElement == null) throw new IllegalStateException("Method must not return null");
            return jsonElement;
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            JsonObject jsonObject = new JsonObject();
            for (Map.Entry entry : map.entrySet()) {
                String name = String.valueOf(entry.getKey());
                Object value = entry.getValue();
                jsonObject.add(name, GsonUtil.wrapYamlObject(value));
            }
            jsonElement = jsonObject;
            if (jsonElement != null) return jsonElement;
            throw new IllegalStateException("Method must not return null");
        }
        if (o instanceof String) {
            return new JsonPrimitive((String)o);
        }
        if (o instanceof Number) {
            return new JsonPrimitive((Number)o);
        }
        if (o instanceof Character) {
            return new JsonPrimitive((Character)o);
        }
        if (!(o instanceof Boolean)) return new JsonPrimitive(String.valueOf(o));
        return new JsonPrimitive((Boolean)o);
    }

    @NotNull
    public static <T> T parseYamlObject(@NotNull Gson gson, @NotNull Class<T> aClass, @NotNull Object o) {
        if (gson == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (aClass == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (o == null) {
            throw new IllegalArgumentException("Parameter 3 must not be null");
        }
        JsonElement element = GsonUtil.wrapYamlObject(o);
        T t = gson.fromJson(element, aClass);
        if (t == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return t;
    }

    public static boolean isValidJson(@Nullable String str) {
        if (str == null || str.trim().isEmpty()) {
            return false;
        }
        try {
            JsonParser.parseString(str);
            return true;
        }
        catch (Throwable exc) {
            return false;
        }
    }

    private static final class MapOfSomething
    implements ParameterizedType {
        @NotNull
        private final Class<?> myKeyClass;
        @NotNull
        private final Class<?> myValueClass;

        public MapOfSomething(@NotNull Class<?> keyClass, @NotNull Class<?> valueClass) {
            if (keyClass == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
            if (valueClass == null) {
                throw new IllegalArgumentException("Parameter 2 must not be null");
            }
            this.myKeyClass = keyClass;
            this.myValueClass = valueClass;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{this.myKeyClass, this.myValueClass};
        }

        @Override
        public Type getRawType() {
            return Map.class;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }
    }

    private static final class CollectionOfSomething<CollectionType extends Collection<?>, ElementType>
    implements ParameterizedType {
        @NotNull
        private final Class<?> myCollectionType;
        @NotNull
        private final Class<?> myElementType;

        public CollectionOfSomething(@NotNull Class<CollectionType> collectionType, @NotNull Class<ElementType> elementType) {
            if (collectionType == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
            if (elementType == null) {
                throw new IllegalArgumentException("Parameter 2 must not be null");
            }
            this.myCollectionType = collectionType;
            this.myElementType = elementType;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{this.myElementType};
        }

        @Override
        public Type getRawType() {
            return this.myCollectionType;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }
    }
}

