/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util;

import com.yourkit.asserts.NotNull;
import com.yourkit.asserts.Nullable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XmlElementIterator
implements Iterator<Element>,
Iterable<Element> {
    private int myNextIndex;
    private final NodeList myChildNodes;
    @Nullable
    private final String myNameOfTags;

    public XmlElementIterator(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this(element, null);
    }

    public XmlElementIterator(@NotNull Element element, @Nullable String nameOfChildrenTags) {
        if (element == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myNameOfTags = nameOfChildrenTags;
        this.myChildNodes = element.getChildNodes();
        this.myNextIndex = 0;
    }

    @Override
    @NotNull
    public Iterator<Element> iterator() {
        XmlElementIterator xmlElementIterator = this;
        if (xmlElementIterator == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return xmlElementIterator;
    }

    @Override
    public boolean hasNext() {
        int count = this.myChildNodes.getLength();
        while (this.myNextIndex < count) {
            Node node = this.myChildNodes.item(this.myNextIndex);
            if (node instanceof Element && (this.myNameOfTags == null || this.myNameOfTags.equals(((Element)node).getTagName()))) {
                return true;
            }
            ++this.myNextIndex;
        }
        return false;
    }

    @Override
    @NotNull
    public Element next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Element element = (Element)this.myChildNodes.item(this.myNextIndex++);
        if (element == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return element;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public int getChildCount() {
        int oldNextIndex = this.myNextIndex;
        int count = 0;
        while (this.hasNext()) {
            this.next();
            ++count;
        }
        this.myNextIndex = oldNextIndex;
        return count;
    }
}

