/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util;

import com.yourkit.asserts.NotNull;
import com.yourkit.asserts.Nullable;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Predicate;

public final class Util {
    @NotNull
    private static final Predicate<Object> ourAlwaysTrue = o -> true;
    @NotNull
    private static final Predicate<Object> ourAlwaysFalse = o -> false;
    @NotNull
    private static final Comparator<Object> ourAlwaysEquals = (o1, o2) -> 0;
    @NotNull
    private static final Runnable ourEmptyRunnable = () -> {};
    @NotNull
    private static final CompletableFuture<?> ourCompletedFuture = CompletableFuture.completedFuture(null);
    @NotNull
    private static final Consumer<?> ourEmptyConsumer = ignored -> {};

    public static void no_op() {
    }

    public static int compare(long v1, long v2) {
        return Long.compare(v1, v2);
    }

    public static int compare(int v1, int v2) {
        return Integer.compare(v1, v2);
    }

    public static int compare(double v1, double v2) {
        return Double.compare(v1, v2);
    }

    public static int compareIgnoreCase(@Nullable String s1, @Nullable String s2) {
        if (s1 == null) {
            return s2 == null ? 0 : -1;
        }
        if (s2 == null) {
            return 1;
        }
        return s1.compareToIgnoreCase(s2);
    }

    public static int roundToInt(double v) {
        return (int)(v >= 0.0 ? v + 0.5 : v - 0.5);
    }

    public static long roundToLong(double v) {
        return (long)(v + 0.5);
    }

    public static int hash(int v1, int v2) {
        return 31 * v1 + v2;
    }

    public static int hash(@NotNull Object o1, @NotNull Object o2) {
        if (o1 == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (o2 == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        return Util.hash(o1.hashCode(), o2.hashCode());
    }

    public static int hash(int v1, int v2, int v3) {
        return 31 * (31 * v1 + v2) + v3;
    }

    public static int hash(int v1, int v2, int v3, int v4) {
        return 31 * (31 * (31 * v1 + v2) + v3) + v4;
    }

    public static void sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void forceGc() {
        Util.forceGc(3);
    }

    public static void forceGc(int count) {
        for (int i = 0; i < count; ++i) {
            System.gc();
        }
    }

    public static void parseKeyValuePair(@NotNull Map<String, String> key2value, @NotNull String keyAndValue) {
        if (key2value == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (keyAndValue == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        int idx = keyAndValue.indexOf(61);
        if (idx == -1) {
            return;
        }
        String key = keyAndValue.substring(0, idx);
        String value = keyAndValue.substring(idx + 1);
        key2value.put(key, value);
    }

    public static int minInt(int a, long b) {
        return (int)Math.min((long)a, b);
    }

    public static int minInt(long a, int b) {
        return (int)Math.min(a, (long)b);
    }

    public static int clamp(int value, int min, int max) {
        return Math.max(Math.min(value, max), min);
    }

    public static long clamp(long value, long min, long max) {
        return Math.max(Math.min(value, max), min);
    }

    public static double clamp(double value, double min, double max) {
        if (min > max) {
            throw new IllegalArgumentException("value=" + value + "; min=" + min + "; max=" + max);
        }
        return Math.max(Math.min(value, max), min);
    }

    public static long roundTo8(long size) {
        return size % 8L == 0L ? size : size / 8L * 8L + 8L;
    }

    public static int scaleInt(int value, int multiplier, int divider) {
        if (value < 0) {
            throw new IllegalArgumentException("Negative value: " + value);
        }
        if (multiplier < 0) {
            throw new IllegalArgumentException("Negative multiplier: " + multiplier);
        }
        if (divider <= 0) {
            throw new IllegalArgumentException("Negative or zero divider: " + divider);
        }
        return Util.minInt((long)value * (long)multiplier / (long)divider, Integer.MAX_VALUE);
    }

    @NotNull
    public static String getCommandLineSpaceSeparated(@NotNull String[] cmd) {
        if (cmd == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        StringBuilder buf = new StringBuilder(80);
        for (int i = 0; i < cmd.length; ++i) {
            String s;
            if (i > 0) {
                buf.append(' ');
            }
            if ((s = cmd[i]).indexOf(32) >= 0 || s.indexOf(9) >= 0) {
                if (s.charAt(0) != '\"') {
                    buf.append('\"');
                    buf.append(s);
                    if (s.endsWith("\\")) {
                        buf.append("\\");
                    }
                    buf.append('\"');
                    continue;
                }
                if (!s.endsWith("\"")) continue;
                buf.append(s);
                continue;
            }
            buf.append(s);
        }
        String string = buf.toString();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @Nullable
    public static <T> T callInstanceMethod(@Nullable Object obj, @NotNull String methodName) {
        if (methodName == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (obj == null) {
            return null;
        }
        Class<?> aClass = obj.getClass();
        try {
            Method m = aClass.getMethod(methodName, new Class[0]);
            m.setAccessible(true);
            return (T)m.invoke(obj, new Object[0]);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @Nullable
    public static <T> T getInstanceField(@Nullable Object obj, @NotNull String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (obj == null) {
            return null;
        }
        try {
            Field f = obj.getClass().getDeclaredField(fieldName);
            f.setAccessible(true);
            return (T)f.get(obj);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @NotNull
    public static String getStringViaInstanceMethod(@Nullable Object obj, @NotNull String methodName) {
        if (methodName == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        Object o = Util.callInstanceMethod(obj, methodName);
        return o instanceof String ? (String)o : "";
    }

    @NotNull
    public static String getAbsolutePathOrEmpty(@Nullable Object fileObj) {
        return fileObj instanceof File ? ((File)fileObj).getAbsolutePath() : "";
    }

    @NotNull
    public static String getPresentableAddress(@Nullable InetAddress requesterAddress) {
        String hostName;
        if (requesterAddress == null) {
            return "null";
        }
        String hostAddress = requesterAddress.getHostAddress();
        String string = hostAddress.equals(hostName = requesterAddress.getHostName()) ? hostAddress : hostName + "(" + hostAddress + ")";
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static <T> ArrayList<T> filterNulls(@NotNull List<T> listWithNulls) {
        if (listWithNulls == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        ArrayList<T> result = new ArrayList<T>();
        for (T element : listWithNulls) {
            if (element == null) continue;
            result.add(element);
        }
        ArrayList<T> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return arrayList;
    }

    public static int tenths(double value) {
        return (int)(value * 10.0) % 10;
    }

    public static <T> T resolve(@NotNull Future<T> future) {
        if (future == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        try {
            return future.get();
        }
        catch (Throwable exc) {
            throw new RuntimeException(exc);
        }
    }

    public static int getPid() {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        return Integer.parseInt(runtime.getName().split("@")[0]);
    }

    @NotNull
    public static <T> Predicate<T> alwaysTrue() {
        Predicate<Object> predicate = ourAlwaysTrue;
        if (predicate == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return predicate;
    }

    @NotNull
    public static <T> Predicate<T> alwaysFalse() {
        Predicate<Object> predicate = ourAlwaysFalse;
        if (predicate == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return predicate;
    }

    @NotNull
    public static <T> Comparator<T> alwaysEquals() {
        Comparator<Object> comparator = ourAlwaysEquals;
        if (comparator == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return comparator;
    }

    @NotNull
    public static RuntimeException toRuntimeException(@NotNull Throwable th) {
        if (th == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return th instanceof RuntimeException ? (RuntimeException)th : new RuntimeException(th);
    }

    @NotNull
    public static Runnable emptyRunnable() {
        Runnable runnable = ourEmptyRunnable;
        if (runnable == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return runnable;
    }

    @NotNull
    public static CompletableFuture<?> completedFuture() {
        CompletableFuture<?> completableFuture = ourCompletedFuture;
        if (completableFuture == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return completableFuture;
    }

    public static <T> Consumer<T> emptyConsumer() {
        return ourEmptyConsumer;
    }

    @Nullable
    public static <T> T resolve(@Nullable Optional<T> o) {
        return o != null && o.isPresent() ? (T)o.get() : null;
    }
}

