/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util;

import com.yourkit.asserts.NotNull;
import com.yourkit.asserts.Nullable;
import com.yourkit.util.FileUtil;
import com.yourkit.util.Strings;
import com.yourkit.util.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;

public final class Properties {
    public static final Handle java_class_path = new Handle("java.class.path");
    public static final Handle java_home = new Handle("java.home");
    public static final Handle java_io_tmpdir = new Handle("java.io.tmpdir");
    public static final Handle java_library_path = new Handle("java.library.path");
    public static final Handle java_runtime_version = new Handle("java.runtime.version");
    @NotNull
    public static final Handle java_vendor = new Handle("java.vendor");
    @NotNull
    public static final Handle java_version = new Handle("java.version");
    @NotNull
    public static final Handle java_vm_info = new Handle("java.vm.info");
    @NotNull
    public static final Handle java_vm_name = new Handle("java.vm.name");
    @NotNull
    public static final Handle java_vm_vendor = new Handle("java.vm.vendor");
    @NotNull
    public static final Handle java_vm_version = new Handle("java.vm.version");
    @NotNull
    public static final Handle os_arch = new Handle("os.arch");
    @NotNull
    public static final Handle os_name = new Handle("os.name");
    @NotNull
    public static final Handle os_version = new Handle("os.version");
    public static final Handle sun_arch_data_model = new Handle("sun.arch.data.model");
    public static final Handle sun_boot_class_path = new Handle("sun.boot.class.path");
    public static final Handle user_home = new Handle("user.home");
    public static final Handle user_name = new Handle("user.name");

    @Nullable
    public static String getProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return System.getProperty(name);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String getProperty(@NotNull String name, @NotNull String defaultValue) {
        String string;
        if (name == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        String property = Properties.getProperty(name);
        if (property != null) {
            string = property;
            if (string == null) throw new IllegalStateException("Method must not return null");
            return string;
        }
        string = defaultValue;
        if (string != null) return string;
        throw new IllegalStateException("Method must not return null");
    }

    @NotNull
    public static String[] getPropertyNames(@NotNull String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        HashSet<String> result = new HashSet<String>();
        for (Object o : System.getProperties().keySet()) {
            String s;
            if (!(o instanceof String) || !(s = (String)o).startsWith(prefix)) continue;
            result.add(s);
        }
        String[] stringArray = result.toArray(new String[0]);
        if (stringArray == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return stringArray;
    }

    public static boolean getBooleanProperty(@NotNull String name, boolean defaultValue) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String property = Properties.getProperty(name);
        if (property != null) {
            return "true".equals(property);
        }
        return defaultValue;
    }

    public static int getIntProperty(@NotNull String name, int defaultValue) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String property = Properties.getProperty(name);
        return Strings.parseInt(property, defaultValue);
    }

    public static double getDoubleProperty(@NotNull String name, double defaultValue) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String property = Properties.getProperty(name);
        Double parsed = Strings.parseDouble(property);
        return parsed != null ? parsed : defaultValue;
    }

    public static void setProperty(@NotNull String name, @Nullable String value) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (value != null) {
            System.setProperty(name, value);
        } else {
            System.clearProperty(name);
        }
    }

    public static boolean isInternal() {
        return Properties.getBooleanProperty("yk.internal", false);
    }

    public static void readPropertiesFromFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        try {
            String content = FileUtil.readUtf8(file);
            for (String _line : content.split("\n")) {
                String line = _line.trim();
                if (!line.startsWith("-D")) continue;
                Properties.parseKeyValuePair(line.substring(2));
            }
        }
        catch (IOException ignored) {
            Logger.warning("Cannot read properties file: " + file);
        }
    }

    public static void parseKeyValuePair(@NotNull String keyAndValue) {
        if (keyAndValue == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (keyAndValue.isEmpty()) {
            return;
        }
        int idx = keyAndValue.indexOf(61);
        if (idx == -1) {
            Properties.setProperty(keyAndValue, "");
            return;
        }
        String key = keyAndValue.substring(0, idx);
        String value = keyAndValue.substring(idx + 1);
        if (value.length() > 1 && value.startsWith("\"") && value.endsWith("\"")) {
            value = value.substring(1, value.length() - 1);
        }
        Properties.setProperty(key, value);
    }

    public static class Handle {
        @NotNull
        private final String myName;

        public Handle(@NotNull String propertyName) {
            if (propertyName == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
            this.myName = propertyName;
        }

        @Nullable
        public String value() {
            return Properties.getProperty(this.myName);
        }

        @NotNull
        public String valueNotNull() {
            String string = Objects.requireNonNull(this.value());
            if (string == null) {
                throw new IllegalStateException("Method must not return null");
            }
            return string;
        }

        public String toString() {
            return this.value();
        }

        @NotNull
        public String value(@NotNull String defaultValue) {
            if (defaultValue == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
            String string = Properties.getProperty(this.myName, defaultValue);
            if (string == null) {
                throw new IllegalStateException("Method must not return null");
            }
            return string;
        }

        @NotNull
        public String name() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException("Method must not return null");
            }
            return string;
        }
    }
}

