/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util;

import com.yourkit.asserts.Asserts;
import com.yourkit.asserts.NotNull;
import com.yourkit.asserts.Nullable;
import com.yourkit.util.UnexpectedValueException;
import java.lang.reflect.Method;

public abstract class JniMethodBase {
    private final boolean myStatic;
    private final long myMethodId;
    private final long myPrimBits;
    @Nullable
    private final Class<?> myClass;
    private final int myReturnTypeSigChar;
    private final int myParameterCount;

    public JniMethodBase(@NotNull Class<?> aClass, @NotNull String methodName, Class<?> ... parameterTypes) throws Exception {
        Method method;
        if (aClass == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (parameterTypes == null) {
            throw new IllegalArgumentException("Parameter 3 must not be null");
        }
        if (parameterTypes.length > 32) {
            Asserts.fail();
        }
        this.myStatic = ((method = this.getDeclaredMethod(aClass, methodName, parameterTypes)).getModifiers() & 8) != 0;
        this.myClass = this.myStatic ? aClass : null;
        this.myParameterCount = parameterTypes.length;
        StringBuilder signature = new StringBuilder();
        signature.append('(');
        long primBits = 0L;
        long bitMask = 1L;
        for (Class<?> type : parameterTypes) {
            JniMethodBase.appendSignature(signature, type);
            if (type.isPrimitive()) {
                primBits |= bitMask;
            }
            bitMask <<= 1;
        }
        signature.append(')');
        int returnTypePos = signature.length();
        JniMethodBase.appendSignature(signature, method.getReturnType());
        this.myReturnTypeSigChar = signature.charAt(returnTypePos);
        this.myPrimBits = primBits;
        try {
            this.myMethodId = this.getMethodIdImpl(method.getDeclaringClass(), methodName, signature.toString(), this.myStatic);
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
    }

    public JniMethodBase(@NotNull Class<?> aClass, @NotNull String name, @NotNull String signature, boolean aStatic) throws Exception {
        if (aClass == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (signature == null) {
            throw new IllegalArgumentException("Parameter 3 must not be null");
        }
        int parameterCount = 0;
        long primBits = 0L;
        int returnTypePos = -1;
        boolean insideNonPrimitive = false;
        long bitMask = 1L;
        for (int i = 0; i < signature.length(); ++i) {
            char ch = signature.charAt(i);
            if (i == 0) {
                if (ch == '(') continue;
                throw new IllegalArgumentException("Invalid signature: does not start with '(': " + signature);
            }
            if (ch == ')') {
                returnTypePos = i + 1;
                break;
            }
            if (insideNonPrimitive) {
                if (ch != ';') continue;
                insideNonPrimitive = false;
                continue;
            }
            if (ch == 'L' || ch == '[') {
                insideNonPrimitive = true;
            } else {
                primBits |= bitMask;
            }
            ++parameterCount;
            bitMask <<= 1;
        }
        if (parameterCount > 32) {
            Asserts.fail();
        }
        this.myStatic = aStatic;
        this.myClass = this.myStatic ? aClass : null;
        this.myParameterCount = parameterCount;
        this.myReturnTypeSigChar = signature.charAt(returnTypePos);
        this.myPrimBits = primBits;
        try {
            this.myMethodId = this.getMethodIdImpl(aClass, name, signature, this.myStatic);
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
    }

    @NotNull
    private Method getDeclaredMethod(@NotNull Class<?> aClass, @NotNull String methodName, @NotNull Class<?>[] parameterTypes) throws Exception {
        if (aClass == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (parameterTypes == null) {
            throw new IllegalArgumentException("Parameter 3 must not be null");
        }
        NoSuchMethodException firstException = null;
        for (Class<?> c = aClass; c != null; c = c.getSuperclass()) {
            Method method;
            try {
                Method method2 = c.getDeclaredMethod(methodName, parameterTypes);
                if (firstException != null && (method2.getModifiers() & 8) != 0) {
                    throw firstException;
                }
                method = method2;
            }
            catch (NoSuchMethodException e) {
                if (firstException != null) continue;
                firstException = e;
                continue;
            }
            if (method == null) {
                throw new IllegalStateException("Method must not return null");
            }
            return method;
        }
        throw firstException;
    }

    public Object invoke(@Nullable Object object, Object ... args) throws Exception {
        if (args == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        this.validateParameters(object, args);
        if (this.myReturnTypeSigChar == 76 || this.myReturnTypeSigChar == 91) {
            return this.callObjectMethodImpl(this.myClass, this.guardObjectArg(object), this.myMethodId, this.myPrimBits, args, this.prepareArgs(args));
        }
        long asLong = this.callPrimOrVoidMethodImpl(this.myClass, this.guardObjectArg(object), this.myMethodId, this.myPrimBits, this.myReturnTypeSigChar, args, this.prepareArgs(args));
        return JniMethodBase.boxPrimitiveValue(asLong, this.myReturnTypeSigChar);
    }

    public long invokePrimitive(@Nullable Object object, Object ... args) throws Exception {
        if (args == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        this.validateParameters(object, args);
        if (this.myReturnTypeSigChar == 76 || this.myReturnTypeSigChar == 91) {
            throw new RuntimeException("Cannot invoke a method with non-primitive return type");
        }
        return this.callPrimOrVoidMethodImpl(this.myClass, this.guardObjectArg(object), this.myMethodId, this.myPrimBits, this.myReturnTypeSigChar, args, this.prepareArgs(args));
    }

    @Nullable
    private long[] prepareArgs(@NotNull Object[] args) {
        if (args == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        int argCount = args.length;
        long[] primArgs = null;
        long bitMask = 1L;
        int i = 0;
        while (i < args.length) {
            if ((this.myPrimBits & bitMask) != 0L) {
                Object arg = args[i];
                if (arg == null) {
                    throw new IllegalArgumentException("argument is null at " + i + ", primitive wrapper expected");
                }
                if (primArgs == null) {
                    primArgs = new long[argCount];
                }
                if (arg instanceof Boolean) {
                    primArgs[i] = Boolean.TRUE.equals(arg) ? 1L : 0L;
                } else if (arg instanceof Float) {
                    primArgs[i] = Float.floatToIntBits(((Float)arg).floatValue());
                } else if (arg instanceof Double) {
                    primArgs[i] = Double.doubleToLongBits((Double)arg);
                } else if (arg instanceof Number) {
                    primArgs[i] = ((Number)arg).longValue();
                } else if (arg instanceof Character) {
                    primArgs[i] = ((Character)arg).charValue();
                } else {
                    throw new IllegalArgumentException("Argument type mismatch at " + i + ": passed " + arg.getClass() + ", primitive wrapper expected");
                }
            }
            ++i;
            bitMask <<= 1;
        }
        return primArgs;
    }

    @NotNull
    public static String getSignature(@NotNull Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        StringBuilder buf = new StringBuilder();
        JniMethodBase.appendSignature(buf, type);
        String string = buf.toString();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    private static void appendSignature(@NotNull StringBuilder buf, @NotNull Class<?> type) {
        if (buf == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        Class<?> t = type;
        while (t.isArray()) {
            buf.append('[');
            t = t.getComponentType();
        }
        if (t.equals(Byte.TYPE)) {
            buf.append('B');
        } else if (t.equals(Character.TYPE)) {
            buf.append('C');
        } else if (t.equals(Double.TYPE)) {
            buf.append('D');
        } else if (t.equals(Float.TYPE)) {
            buf.append('F');
        } else if (t.equals(Integer.TYPE)) {
            buf.append('I');
        } else if (t.equals(Long.TYPE)) {
            buf.append('J');
        } else if (t.equals(Short.TYPE)) {
            buf.append('S');
        } else if (t.equals(Boolean.TYPE)) {
            buf.append('Z');
        } else if (t.equals(Void.TYPE)) {
            buf.append('V');
        } else {
            buf.append('L');
            buf.append(t.getName().replace('.', '/'));
            buf.append(';');
        }
    }

    private void validateParameters(@Nullable Object object, @NotNull Object[] args) {
        if (args == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (!this.myStatic && object == null) {
            throw new IllegalArgumentException("Object must not be null when calling an instance method");
        }
        if (args.length != this.myParameterCount) {
            throw new IllegalArgumentException("Parameter count mismatch: passed " + args.length + " but expected " + this.myParameterCount);
        }
    }

    @Nullable
    static Object boxPrimitiveValue(long asLong, int sigChar) {
        switch (sigChar) {
            case 90: {
                return asLong != 0L;
            }
            case 67: {
                return Character.valueOf((char)asLong);
            }
            case 66: {
                return (byte)asLong;
            }
            case 83: {
                return (short)asLong;
            }
            case 73: {
                return (int)asLong;
            }
            case 74: {
                return asLong;
            }
            case 70: {
                return Float.valueOf(Float.intBitsToFloat((int)asLong));
            }
            case 68: {
                return Double.longBitsToDouble(asLong);
            }
            case 86: {
                if (asLong != 0L) {
                    Asserts.fail();
                }
                return null;
            }
        }
        throw new UnexpectedValueException(sigChar);
    }

    @Nullable
    private Object guardObjectArg(Object object) {
        return this.myStatic ? null : object;
    }

    protected abstract long getMethodIdImpl(@NotNull Class<?> var1, @NotNull String var2, @NotNull String var3, boolean var4) throws Throwable;

    protected abstract Object callObjectMethodImpl(@Nullable Class<?> var1, @Nullable Object var2, long var3, long var5, @NotNull Object[] var7, @Nullable long[] var8) throws Exception;

    protected abstract long callPrimOrVoidMethodImpl(@Nullable Class<?> var1, @Nullable Object var2, long var3, long var5, int var7, @NotNull Object[] var8, @Nullable long[] var9) throws Exception;
}

