/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util;

import com.yourkit.asserts.NotNull;
import com.yourkit.asserts.Nullable;
import com.yourkit.util.IntRef;
import com.yourkit.util.Properties;
import com.yourkit.util.Strings;

public final class JavaVersion {
    public static int getJavaVersion(@NotNull String versionStr) {
        if (versionStr == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        int version = versionStr.startsWith("1.") ? Strings.parseIntPrefix(versionStr.substring(2), 0) : Strings.parseIntPrefix(versionStr, 0);
        return Math.max(version, 0);
    }

    public static boolean isNonAttachableIbmJava(@NotNull String javaVersionOutput) {
        if (javaVersionOutput == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return javaVersionOutput.contains("IBM J9 VM") && !JavaVersion.isOpenJ9(javaVersionOutput);
    }

    public static boolean isOpenJ9(@NotNull String javaVersionOutput) {
        if (javaVersionOutput == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return javaVersionOutput.contains("OpenJ9");
    }

    public static boolean isJava11orNewer(@NotNull String javaVersionOutput) {
        if (javaVersionOutput == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return JavaVersion.retrieveJavaVersion(javaVersionOutput) >= 11;
    }

    public static boolean isUnsupportedJavaVersion(@NotNull String javaVersionOutput, @Nullable IntRef op_version) {
        if (javaVersionOutput == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        int version = JavaVersion.retrieveJavaVersion(javaVersionOutput);
        if (op_version != null) {
            op_version.set(version);
        }
        boolean isAttachToNewerJavaAllowed = Properties.getBooleanProperty("yjp.allow-attach-to-newer-java", false);
        return version < 8 || version > 24 && !isAttachToNewerJavaAllowed;
    }

    public static int retrieveJavaVersion(@NotNull String javaVersionOutput) {
        if (javaVersionOutput == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        for (String prefix : new String[]{"openjdk version \"", "java version \""}) {
            int idx = javaVersionOutput.indexOf(prefix);
            if (idx < 0) continue;
            return JavaVersion.getJavaVersion(javaVersionOutput.substring(idx + prefix.length()));
        }
        return 0;
    }
}

