/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util;

import com.yourkit.Constants;
import com.yourkit.asserts.Asserts;
import com.yourkit.asserts.NotNull;
import com.yourkit.asserts.Nullable;
import com.yourkit.util.ArrayUtil;
import com.yourkit.util.BoolRef;
import com.yourkit.util.Os;
import com.yourkit.util.Pair;
import com.yourkit.util.Properties;
import com.yourkit.util.Strings;
import com.yourkit.util.Value;
import com.yourkit.util.logging.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;

public final class FileUtil {
    public static final File[] FILE_EMPTY_ARRAY = new File[0];

    public static boolean isParent(@NotNull File parent, @NotNull File child) {
        if (parent == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (child == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        File _parent = FileUtil.getCanonicalFileOrThrow(parent);
        File _child = FileUtil.getCanonicalFileOrThrow(child);
        for (File d = _child.getParentFile(); d != null; d = d.getParentFile()) {
            if (!d.equals(_parent)) continue;
            return true;
        }
        return false;
    }

    public static void copy(@NotNull InputStream in, @NotNull OutputStream out) throws IOException {
        int length;
        if (in == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (out == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        byte[] buffer = new byte[4096];
        while ((length = in.read(buffer)) != -1) {
            out.write(buffer, 0, length);
        }
    }

    public static void copy(@NotNull File source, @NotNull File destination) throws IOException {
        if (source == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        try (FileInputStream in = new FileInputStream(source);
             FileOutputStream out = new FileOutputStream(destination);){
            FileUtil.copy(in, out);
        }
    }

    @NotNull
    public static byte[] read(@NotNull InputStream stream) throws IOException {
        byte[] byArray;
        block13: {
            if (stream == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                FileUtil.copy(stream, output);
                output.flush();
                byArray = output.toByteArray();
                if (byArray != null) break block13;
            }
            throw new IllegalStateException("Method must not return null");
        }
        return byArray;
    }

    public static void read(@NotNull Reader reader, @NotNull StringBuilder buffer) throws IOException {
        int readCharCount;
        if (reader == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (buffer == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        char[] buff = new char[4096];
        while ((readCharCount = reader.read(buff, 0, buff.length)) != -1) {
            buffer.append(buff, 0, readCharCount);
        }
    }

    @NotNull
    public static File getCanonicalFileOrThrow(@NotNull File file) {
        File file2;
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        try {
            file2 = file.getCanonicalFile();
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
        if (file2 == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return file2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static String normalize(@NotNull File file) {
        String string;
        String string2;
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        try {
            string2 = file.getCanonicalPath();
        }
        catch (IOException ignored) {
            String absolutePath = file.getAbsolutePath();
            string = Constants.OS_WINDOWS ? absolutePath.toLowerCase() : absolutePath;
            if (string == null) throw new IllegalStateException("Method must not return null");
            return string;
        }
        string = string2;
        if (string2 == null) throw new IllegalStateException("Method must not return null");
        return string;
    }

    @NotNull
    public static String normalizeDirectory(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String result = FileUtil.normalize(file);
        String string = result.endsWith(File.separator) ? result : result + File.separator;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public static boolean hasExtension(@NotNull File file, @NotNull String extension) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (extension == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        return FileUtil.hasExtension(file.getName(), extension);
    }

    public static boolean hasExtension(@NotNull String fileName, @NotNull String extension) {
        if (fileName == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (extension == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (Os.getCurrent().isWindows()) {
            return Strings.endsWithIgnoreCase(fileName, extension);
        }
        return fileName.endsWith(extension);
    }

    public static boolean hasName(@NotNull File file, @NotNull String name) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (Constants.OS_WINDOWS) {
            return file.getName().equalsIgnoreCase(name);
        }
        return file.getName().equals(name);
    }

    public static boolean nameStartsWith(@NotNull File file, @NotNull String prefix) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (prefix == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        String name = file.getName();
        if (Constants.OS_WINDOWS) {
            return name.toLowerCase().startsWith(prefix);
        }
        return name.startsWith(prefix);
    }

    @NotNull
    public static String getNameWithoutExtension(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        int index = fileName.lastIndexOf(46);
        String string = index == -1 ? fileName : fileName.substring(0, index);
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static Pair<String, String> getNameAndExtension(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String name = FileUtil.getNameWithoutExtension(fileName);
        String extension = fileName.substring(name.length());
        return new Pair<String, String>(name, extension);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String validateTempFilePrefix(@NotNull String prefix) {
        String string;
        if (prefix == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        int length = prefix.length();
        if (length == 0) {
            return "___";
        }
        if (length == 1) {
            string = prefix + "__";
            if (string == null) throw new IllegalStateException("Method must not return null");
            return string;
        }
        if (length == 2) {
            string = prefix + "_";
            if (string == null) throw new IllegalStateException("Method must not return null");
            return string;
        }
        string = prefix;
        if (string != null) return string;
        throw new IllegalStateException("Method must not return null");
    }

    @NotNull
    public static String getExtension(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        int index = fileName.lastIndexOf(46);
        String string = index == -1 ? "" : fileName.substring(index);
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public static void setExecutableAttributeAsync(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (Constants.OS_WINDOWS) {
            Asserts.fail();
        }
        try {
            Runtime.getRuntime().exec("chmod ugoa+x " + file.getName(), null, file.getParentFile());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean hasSnapshotExtension(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return FileUtil.hasExtension(fileName, ".snapshot");
    }

    public static boolean hasAnySnapshotExtension(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return FileUtil.hasAnySnapshotExtension(file.getName());
    }

    public static boolean hasAnySnapshotExtension(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return FileUtil.hasSnapshotExtension(name, "");
    }

    public static boolean hasGzippedSnapshotExtension(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return FileUtil.hasSnapshotExtension(file.getName(), ".gz");
    }

    public static boolean hasZstdSnapshotExtension(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return FileUtil.hasSnapshotExtension(file.getName(), ".zst") || FileUtil.hasSnapshotExtension(file.getName(), ".zstd");
    }

    private static boolean hasSnapshotExtension(@NotNull String name, @NotNull String extension) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (extension == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        return FileUtil.hasExtension(name, ".snapshot" + extension) || FileUtil.hasExtension(name, ".phd" + extension) || FileUtil.hasExtension(name, ".jfr" + extension) || FileUtil.hasExtension(name, ".hprof" + extension);
    }

    public static boolean hasZipExtension(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return FileUtil.hasExtension(file, ".zip");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String cutSnapshotExtension(@NotNull String fileName) {
        String string;
        if (fileName == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String extension = ".snapshot";
        if (FileUtil.hasExtension(fileName, ".snapshot")) {
            string = fileName.substring(0, fileName.length() - ".snapshot".length());
            if (string == null) throw new IllegalStateException("Method must not return null");
            return string;
        }
        string = fileName;
        if (string != null) return string;
        throw new IllegalStateException("Method must not return null");
    }

    @NotNull
    public static File[] toArray(@NotNull Collection<File> c) {
        if (c == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        File[] fileArray = c.toArray(new File[0]);
        if (fileArray == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return fileArray;
    }

    public static String getOwnJavaExecutablePath(boolean withJavaW) {
        return new File(Properties.java_home.valueNotNull(), Constants.OS_WINDOWS ? (withJavaW ? "bin\\javaw.exe" : "bin\\java.exe") : "bin/java").getAbsolutePath();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String expand(@NotNull String path) {
        String string;
        if (path == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String homeDirPrefix = "~/";
        if (path.startsWith("~/")) {
            string = Properties.user_home.valueNotNull() + "/" + path.substring("~/".length());
            if (string == null) throw new IllegalStateException("Method must not return null");
            return string;
        }
        string = path;
        if (string != null) return string;
        throw new IllegalStateException("Method must not return null");
    }

    @NotNull
    public static File expandAsFile(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return new File(FileUtil.expand(path));
    }

    public static void visitDirectoryInDepth(@NotNull File dir, @NotNull DirectoryVisitor visitor) throws IOException {
        if (dir == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (visitor == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (visitor.isStopped()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                visitor.visitDirectoryBeforeVisitingContent(file);
                if (visitor.isStopped()) {
                    return;
                }
                FileUtil.visitDirectoryInDepth(file, visitor);
                visitor.visitDirectoryAfterVisitingContent(file);
                if (!visitor.isStopped()) continue;
                return;
            }
            visitor.visitFile(file);
            if (!visitor.isStopped()) continue;
            return;
        }
    }

    public static void visitDirectoryPlain(@NotNull File dir, @NotNull DirectoryVisitor visitor) throws IOException {
        if (dir == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (visitor == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            visitor.visitFile(file);
        }
    }

    @NotNull
    public static byte[] read(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        long fileLength = file.length();
        if (fileLength > 0x7FFFFFF7L) {
            throw new IOException("File is too big: " + file.getAbsolutePath());
        }
        byte[] byArray = FileUtil.read(file, (int)fileLength);
        if (byArray == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return byArray;
    }

    @NotNull
    public static byte[] read(@NotNull File file, int bytesToRead) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        byte[] result = new byte[bytesToRead];
        try (DataInputStream stream = new DataInputStream(new FileInputStream(file));){
            stream.readFully(result);
        }
        if (result == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return result;
    }

    @NotNull
    public static String readUtf8(@NotNull InputStream input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        byte[] bytes = FileUtil.read(input);
        String string = Strings.createUtf8String(bytes);
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static String readUtf8(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        byte[] bytes = FileUtil.read(file);
        String string = Strings.createUtf8String(bytes);
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @Nullable
    public static String readUtf8Safe(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        try {
            return FileUtil.readUtf8(file);
        }
        catch (IOException ignored) {
            return null;
        }
    }

    @NotNull
    public static String readTextFileUtf8(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String result = FileUtil.readUtf8(file);
        String string = Constants.OS_WINDOWS ? Strings.replace(result, "\r\n", "\n") : result;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public static void readFully(@NotNull Reader reader, @NotNull char[] buffer) throws IOException {
        int count;
        if (reader == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (buffer == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        int len = buffer.length;
        for (int n = 0; n < len; n += count) {
            count = reader.read(buffer, n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    public static void readFully(@NotNull InputStream input, @NotNull byte[] buffer) throws IOException {
        int count;
        if (input == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (buffer == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        int len = buffer.length;
        for (int n = 0; n < len; n += count) {
            count = input.read(buffer, n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    @NotNull
    public static String readAscii(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        byte[] bytes = FileUtil.read(file);
        StringBuilder builder = new StringBuilder(bytes.length);
        for (byte b : bytes) {
            int bb = b & 0xFF;
            builder.append((char)(bb < 128 ? (int)bb : 32));
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public static void writeUtf8(@NotNull File file, @NotNull String str, int flags) throws IOException {
        boolean convertEol;
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (str == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        boolean makeParents = (flags & 1) != 0;
        boolean append = (flags & 2) != 0;
        boolean appendLn = (flags & 4) != 0;
        boolean bl = convertEol = Constants.OS_WINDOWS && (flags & 8) != 0;
        if (makeParents) {
            FileUtil.ensureParentDirsExist(file);
        }
        try (BufferedOutputStream w = new BufferedOutputStream(new FileOutputStream(file, append));){
            String strConverted = convertEol ? Strings.replace(str, "\n", "\r\n") : str;
            w.write(Strings.getUtf8Bytes(strConverted));
            if (appendLn) {
                if (convertEol) {
                    w.write(13);
                }
                w.write(10);
            }
        }
    }

    public static void write(@NotNull File file, @NotNull byte[] content) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (content == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));){
            stream.write(content);
        }
    }

    public static void append(@NotNull File file, @NotNull byte[] content) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (content == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file, true));){
            stream.write(content);
        }
    }

    public static void writeUtf8(@NotNull File file, @NotNull String content) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (content == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        FileUtil.writeUtf8(file, content, 0);
    }

    public static void writeTextFileUtf8(@NotNull File file, @NotNull String content) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (content == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        FileUtil.writeUtf8(file, content, 8);
    }

    public static String[] readLines(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        try (FileInputStream stream = new FileInputStream(file);){
            String[] stringArray = FileUtil.readLines(stream);
            return stringArray;
        }
    }

    public static String[] readLines(@NotNull InputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return FileUtil.readLines(stream, Strings.UTF_8);
    }

    public static String[] readLines(@NotNull InputStream stream, @NotNull Charset charset) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (charset == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        ArrayList<String> result = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, charset));){
            String s;
            while ((s = reader.readLine()) != null) {
                result.add(s);
            }
        }
        return ArrayUtil.toArray(result);
    }

    public static boolean equalPaths(@Nullable File file1, @Nullable File file2) {
        if (file1 == null || file2 == null) {
            return file1 == file2;
        }
        if (Os.getCurrent().isWindows()) {
            return FileUtil.normalize(file1).equalsIgnoreCase(FileUtil.normalize(file2));
        }
        return FileUtil.normalize(file1).equals(FileUtil.normalize(file2));
    }

    public static boolean mkdirsSafe(@NotNull File dir) {
        if (dir == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        boolean created = dir.mkdirs();
        return created || dir.exists();
    }

    public static boolean delete(@NotNull File file) {
        boolean ok;
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        final BoolRef error = new BoolRef();
        if (file.isDirectory()) {
            try {
                FileUtil.visitDirectoryInDepth(file, new DirectoryVisitorAdapter(){

                    @Override
                    public void visitFile(@NotNull File file) {
                        if (file == null) {
                            throw new IllegalArgumentException("Parameter 1 must not be null");
                        }
                        if (!file.delete()) {
                            error.set(true);
                        }
                    }

                    @Override
                    public void visitDirectoryAfterVisitingContent(@NotNull File directory) {
                        if (directory == null) {
                            throw new IllegalArgumentException("Parameter 1 must not be null");
                        }
                        if (!directory.delete()) {
                            error.set(true);
                        }
                    }
                });
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return (ok = file.delete()) && !error.get();
    }

    public static boolean equalBinaryFiles(@NotNull String file1, @NotNull String file2) throws IOException {
        if (file1 == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (file2 == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (new File(file1).length() != new File(file2).length()) {
            return false;
        }
        try (BufferedInputStream s1 = new BufferedInputStream(new FileInputStream(file1));
             DataInputStream s2 = new DataInputStream(new BufferedInputStream(new FileInputStream(file2)));){
            int length;
            byte[] buffer1 = new byte[131072];
            byte[] buffer2 = new byte[buffer1.length];
            while ((length = ((InputStream)s1).read(buffer1)) != -1) {
                s2.readFully(buffer2, 0, length);
                for (int i = 0; i < length; ++i) {
                    if (buffer1[i] == buffer2[i]) continue;
                    boolean bl = false;
                    return bl;
                }
            }
        }
        return true;
    }

    @NotNull
    public static File[] listFilesSafe(@NotNull File directory) {
        if (directory == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        File[] fileArray = Value.notNull(directory.listFiles(), FILE_EMPTY_ARRAY);
        if (fileArray == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return fileArray;
    }

    public static boolean isAllowedFileNameCharacter(char c) {
        return c >= ' ' && "\\/<>|\":?*".indexOf(c) < 0;
    }

    public static boolean isFileNameValid(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        try {
            file.getCanonicalPath();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @NotNull
    public static String toFileNamePart(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        StringBuilder result = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (FileUtil.isAllowedFileNameCharacter(ch)) {
                result.append(ch);
                continue;
            }
            result.append('-');
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static File getTempDir() {
        return new File(Properties.java_io_tmpdir.valueNotNull());
    }

    @NotNull
    public static File createTempFile(@NotNull String prefix, @NotNull String extension) throws IOException {
        if (prefix == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (extension == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        File tempDir = FileUtil.getTempDir();
        Random random = new Random();
        int i = 1;
        while (true) {
            int runningNumber = i < 100 ? i : Math.abs(random.nextInt());
            File f = new File(tempDir, prefix + runningNumber + extension);
            if (f.createNewFile()) {
                File file = f;
                if (file == null) {
                    throw new IllegalStateException("Method must not return null");
                }
                return file;
            }
            ++i;
        }
    }

    public static boolean canWrite(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (Constants.OS_WINDOWS && file.isDirectory()) {
            try {
                FileUtil.delete(File.createTempFile("yjp_chk_", ".tmp", file));
            }
            catch (IOException ignored) {
                return false;
            }
        }
        return file.canWrite();
    }

    public static void ensureParentDirsExist(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        File parent = file.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
    }

    @NotNull
    public static File createTempDir(@NotNull String prefix) throws IOException {
        if (prefix == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        File file = Files.createTempDirectory(prefix, new FileAttribute[0]).toFile();
        if (file == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return file;
    }

    public static boolean moveDirContentToDir(@NotNull File srcDir, @NotNull File dstDir) {
        if (srcDir == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (dstDir == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (!dstDir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + dstDir);
        }
        if (!srcDir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + srcDir);
        }
        final Path srcPath = srcDir.toPath();
        final Path dstPath = dstDir.toPath();
        final BoolRef success = new BoolRef(true);
        try {
            Files.walkFileTree(srcPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFileFailed(@NotNull Path file, @NotNull IOException e) {
                    if (file == null) {
                        throw new IllegalArgumentException("Parameter 1 must not be null");
                    }
                    if (e == null) {
                        throw new IllegalArgumentException("Parameter 2 must not be null");
                    }
                    success.set(false);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(@NotNull Path dir, @Nullable IOException e) {
                    if (dir == null) {
                        throw new IllegalArgumentException("Parameter 1 must not be null");
                    }
                    if (e != null) {
                        success.set(false);
                    } else if (!dir.equals(srcPath)) {
                        try {
                            Files.delete(dir);
                        }
                        catch (IOException exc) {
                            success.set(false);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(@NotNull Path dir, @NotNull BasicFileAttributes attrs) {
                    if (dir == null) {
                        throw new IllegalArgumentException("Parameter 1 must not be null");
                    }
                    if (attrs == null) {
                        throw new IllegalArgumentException("Parameter 2 must not be null");
                    }
                    Path target = dstPath.resolve(srcPath.relativize(dir));
                    File targetFile = target.toFile();
                    try {
                        if (!targetFile.exists()) {
                            Files.createDirectory(target, new FileAttribute[0]);
                        } else if (targetFile.isFile()) {
                            Files.delete(target);
                            Files.createDirectory(target, new FileAttribute[0]);
                        }
                    }
                    catch (IOException exc) {
                        success.set(false);
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) {
                    if (file == null) {
                        throw new IllegalArgumentException("Parameter 1 must not be null");
                    }
                    if (attrs == null) {
                        throw new IllegalArgumentException("Parameter 2 must not be null");
                    }
                    Path target = dstPath.resolve(srcPath.relativize(file));
                    File targetFile = target.toFile();
                    if (targetFile.isDirectory()) {
                        success.set(false);
                        return FileVisitResult.CONTINUE;
                    }
                    try {
                        Files.move(file, target, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException exc) {
                        success.set(false);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException exc) {
            success.set(false);
        }
        return success.get();
    }

    public static boolean restrictAccessSafe(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        try {
            FileUtil.restrictAccess(file);
            return true;
        }
        catch (IOException exc) {
            Logger.error("Cannot restrict access to " + file, exc);
            return false;
        }
    }

    public static void restrictAccess(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        file.createNewFile();
        if (!Constants.OS_WINDOWS) {
            HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
            permissions.add(PosixFilePermission.OWNER_READ);
            permissions.add(PosixFilePermission.OWNER_WRITE);
            Files.setPosixFilePermissions(file.toPath(), permissions);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isEmptyDir(@NotNull File dir) {
        if (dir == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir.toPath());){
            boolean bl = !stream.iterator().hasNext();
            return bl;
        }
        catch (Exception exc) {
            return false;
        }
    }

    public static class DirectoryVisitorAdapter
    implements DirectoryVisitor {
        private boolean myStopped;

        @Override
        public boolean isStopped() {
            return this.myStopped;
        }

        public final void stopIterations() {
            this.myStopped = true;
        }

        @Override
        public void visitFile(@NotNull File file) throws IOException {
            if (file == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
        }

        @Override
        public void visitDirectoryBeforeVisitingContent(@NotNull File directory) throws IOException {
            if (directory == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
        }

        @Override
        public void visitDirectoryAfterVisitingContent(@NotNull File directory) throws IOException {
            if (directory == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
        }
    }

    public static interface DirectoryVisitor {
        public boolean isStopped();

        public void visitFile(@NotNull File var1) throws IOException;

        public void visitDirectoryBeforeVisitingContent(@NotNull File var1) throws IOException;

        public void visitDirectoryAfterVisitingContent(@NotNull File var1) throws IOException;
    }

    public static final class Flags {
        public static final int NONE = 0;
        public static final int MAKE_PARENTS = 1;
        public static final int APPEND = 2;
        public static final int LN = 4;
        public static final int TEXT_MODE = 8;
    }
}

