/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.controller.http;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.yourkit.api.ProbeActivityMode;
import com.yourkit.api.controller.ControllerException;
import com.yourkit.asserts.NotNull;
import com.yourkit.asserts.Nullable;
import com.yourkit.util.http.HttpClient;
import com.yourkit.util.http.HttpStatus;
import com.yourkit.util.http.HttpUri;
import com.yourkit.util.http.Protocol;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.util.Objects;

public final class HttpTransport {
    @NotNull
    public static final Gson GSON = HttpTransport.createGson();
    @NotNull
    private final InetSocketAddress myAddress;
    @NotNull
    private final String myReverseProxyPath;
    private final boolean myTrustAllSslCertificates;
    private final int myConnectTimeoutMs;
    private final int myReadTimeoutMs;
    @NotNull
    private final String myApiVersion;

    private HttpTransport(@NotNull InetSocketAddress address, @NotNull String apiVersion, @NotNull String reverseProxyPath, boolean trustAllSslCertificates, int connectTimeoutMs, int readTimeoutMs) {
        if (address == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (apiVersion == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (reverseProxyPath == null) {
            throw new IllegalArgumentException("Parameter 3 must not be null");
        }
        this.myAddress = address;
        this.myApiVersion = apiVersion;
        this.myReverseProxyPath = reverseProxyPath;
        this.myTrustAllSslCertificates = trustAllSslCertificates;
        this.myConnectTimeoutMs = connectTimeoutMs;
        this.myReadTimeoutMs = readTimeoutMs;
    }

    @NotNull
    public static Builder newBuilder() {
        return new Builder();
    }

    @NotNull
    public InetSocketAddress getAddress() {
        InetSocketAddress inetSocketAddress = this.myAddress;
        if (inetSocketAddress == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return inetSocketAddress;
    }

    @NotNull
    private static Gson createGson() {
        Gson gson = new GsonBuilder().disableHtmlEscaping().excludeFieldsWithoutExposeAnnotation().registerTypeAdapter((Type)((Object)ProbeActivityMode.class), new ProbeActivityModeTypeAdapter()).create();
        if (gson == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return gson;
    }

    @NotNull
    public String getHttpApiPath() {
        StringBuilder result = new StringBuilder();
        if (!this.myReverseProxyPath.startsWith("/")) {
            result.append('/');
        }
        result.append(this.myReverseProxyPath);
        if (result.charAt(result.length() - 1) != '/') {
            result.append('/');
        }
        result.append("yjp/api/").append(this.myApiVersion);
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public JsonElement doRequest(@NotNull String actionPath, @Nullable Object param) throws IOException {
        if (actionPath == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        HttpUri uri = new HttpUri().setProtocol(Protocol.HTTPS).setHost(this.myAddress.getHostString()).setPort(this.myAddress.getPort()).setPath(this.getHttpApiPath() + "/" + actionPath);
        HttpClient client = new HttpClient(uri).setTrustAllSslCertificates(this.myTrustAllSslCertificates).setConnectTimeoutMs(this.myConnectTimeoutMs).setReadTimeoutMs(this.myReadTimeoutMs).doJson(param != null ? GSON.toJson(param) : "{}");
        int status = client.invoke();
        String response = client.getContent().trim();
        if (status == HttpStatus.OK.myCode) {
            response = response.isEmpty() ? "{}" : response;
            JsonElement jsonElement = JsonParser.parseString(response);
            if (jsonElement == null) {
                throw new IllegalStateException("Method must not return null");
            }
            return jsonElement;
        }
        throw new ControllerException("status=" + status + "; uri=" + uri + "; response=" + response);
    }

    private static final class ProbeActivityModeTypeAdapter
    extends TypeAdapter<ProbeActivityMode> {
        private ProbeActivityModeTypeAdapter() {
        }

        @Override
        public void write(@NotNull JsonWriter writer, @NotNull ProbeActivityMode mode) throws IOException {
            String str;
            if (writer == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
            if (mode == null) {
                throw new IllegalArgumentException("Parameter 2 must not be null");
            }
            if (mode == ProbeActivityMode.OFF) {
                str = "off";
            } else if (mode == ProbeActivityMode.ON) {
                str = "on";
            } else if (mode == ProbeActivityMode.AUTO) {
                str = "auto";
            } else {
                throw new RuntimeException("Unknown mode=" + (Object)((Object)mode));
            }
            Streams.write(new JsonPrimitive(str), writer);
        }

        @Override
        public ProbeActivityMode read(@NotNull JsonReader reader) throws IOException {
            if (reader == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
            String str = Streams.parse(reader).getAsString();
            if ("off".equals(str)) {
                return ProbeActivityMode.OFF;
            }
            if ("on".equals(str)) {
                return ProbeActivityMode.ON;
            }
            if ("auto".equals(str)) {
                return ProbeActivityMode.AUTO;
            }
            throw new RuntimeException("Unknown mode=" + str);
        }
    }

    public static final class Builder {
        @Nullable
        private String myHost;
        private int myPort;
        @Nullable
        private String myApiVersion;
        @Nullable
        private String myReverseProxyPath;
        private boolean myTrustAllSslCertificates = true;
        private int myConnectTimeoutMs;
        private int myReadTimeoutMs;

        private Builder() {
        }

        @NotNull
        public Builder host(@Nullable String host) {
            this.myHost = host;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException("Method must not return null");
            }
            return builder;
        }

        @NotNull
        public Builder port(int port) {
            this.myPort = port;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException("Method must not return null");
            }
            return builder;
        }

        @NotNull
        public Builder apiVersion(@NotNull String version) {
            if (version == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
            this.myApiVersion = version;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException("Method must not return null");
            }
            return builder;
        }

        @NotNull
        public Builder reverseProxyPath(@Nullable String path) {
            this.myReverseProxyPath = path;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException("Method must not return null");
            }
            return builder;
        }

        @NotNull
        public Builder trustAllSslCertificates(boolean trust) {
            this.myTrustAllSslCertificates = trust;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException("Method must not return null");
            }
            return builder;
        }

        @NotNull
        public Builder connectTimeout(int ms) {
            this.myConnectTimeoutMs = ms;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException("Method must not return null");
            }
            return builder;
        }

        @NotNull
        public Builder readTimeout(int ms) {
            this.myReadTimeoutMs = ms;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException("Method must not return null");
            }
            return builder;
        }

        @NotNull
        public HttpTransport build() {
            Objects.requireNonNull(this.myHost, "Host is not specified");
            Objects.requireNonNull(this.myApiVersion, "API version is not specified");
            String reverseProxyPath = this.myReverseProxyPath != null ? this.myReverseProxyPath : "";
            return new HttpTransport(InetSocketAddress.createUnresolved(this.myHost, this.myPort), this.myApiVersion, reverseProxyPath, this.myTrustAllSslCertificates, this.myConnectTimeoutMs, this.myReadTimeoutMs);
        }
    }
}

