/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.controller;

import java.util.HashMap;

public class ProfilingModesExt {
    private static final long ALLOCATION_PROFILING_BIT = 2L;
    private static final long ALLOCATION_PROFILING_SAMPLED_STACKS_BIT = 8192L;
    private static final long ALLOCATION_PROFILING_OBJECT_COUNTING_BIT = 16384L;
    private static final long ALLOCATION_PROFILING_HEAP_SAMPLING_BIT = 524288L;
    private static final long CPU_PROFILING_BIT = 4L;
    private static final long CPU_TRACING_BIT = 8L;
    private static final long CPU_CALL_COUNTING_BIT = 4096L;
    public static final long SAMPLING_MODE_ASYNC_CPU = 131072L;
    public static final long SAMPLING_MODE_ASYNC_PERIODIC = 262144L;
    public static final long INTERNAL_ERROR_BIT = 256L;
    public static final long ALLOCATION_PROFILING = 548866L;
    public static final long ALLOCATION_PROFILING_EXACT_STACKS = 2L;
    public static final long ALLOCATION_PROFILING_SAMPLED_STACKS = 8194L;
    public static final long ALLOCATION_PROFILING_OBJECT_COUNTING = 16386L;
    public static final long ALLOCATION_PROFILING_HEAP_SAMPLING = 524290L;
    public static final long CPU_PROFILING = 4108L;
    public static final long CPU_SAMPLING = 4L;
    public static final long CPU_TRACING = 12L;
    public static final long CPU_CALL_COUNTING = 4100L;
    public static final long SAMPLING_MODE = 393216L;

    public static boolean isAllocModeExactStacks(long status) {
        return (status & 0x86002L) == 2L;
    }

    public static boolean isAllocModeSampledStacks(long status) {
        return (status & 0x86002L) == 8194L;
    }

    public static boolean isAllocModeObjectCounting(long status) {
        return (status & 0x86002L) == 16386L;
    }

    public static boolean isAllocModeHeapSampling(long status) {
        return (status & 0x86002L) == 524290L;
    }

    public static boolean isCpuProfiling(long status) {
        return (status & 4L) != 0L;
    }

    public static boolean isSampling(long status) {
        return (status & 0x100CL) == 4L;
    }

    public static boolean isTracing(long status) {
        return (status & 0x100CL) == 12L;
    }

    public static boolean isCallCounting(long status) {
        return (status & 0x100CL) == 4100L;
    }

    public static boolean isSamplingModeAsyncCpu(long status) {
        return (status & 0x60000L) == 131072L;
    }

    public static boolean isSamplingModeAsyncPeriodic(long status) {
        return (status & 0x60000L) == 262144L;
    }

    public static boolean isCpuTracingBit(long status) {
        return (status & 8L) != 0L;
    }

    public static boolean isCpuCallCountingBit(long status) {
        return (status & 0x1000L) != 0L;
    }

    public static HashMap<Long, String> getMaskPresentation() {
        HashMap<Long, String> map = new HashMap<Long, String>();
        map.put(2L, "ALLOCATION_PROFILING_BIT");
        map.put(8192L, "ALLOCATION_PROFILING_SAMPLED_STACKS_BIT");
        map.put(16384L, "ALLOCATION_PROFILING_OBJECT_COUNTING_BIT");
        map.put(524288L, "ALLOCATION_PROFILING_HEAP_SAMPLING_BIT");
        map.put(4L, "CPU_PROFILING_BIT");
        map.put(8L, "CPU_TRACING_BIT");
        map.put(4096L, "CPU_CALL_COUNTING_BIT");
        map.put(131072L, "SAMPLING_MODE_ASYNC_CPU");
        map.put(262144L, "SAMPLING_MODE_ASYNC_PERIODIC");
        map.put(256L, "INTERNAL_ERROR_BIT");
        return map;
    }
}

