/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.asserts;

import com.yourkit.asserts.NotNull;
import com.yourkit.asserts.Nullable;
import java.awt.EventQueue;
import java.util.Objects;

public final class Asserts {
    private static boolean ourHeadless = true;

    private Asserts() {
    }

    @NotNull
    public static <T> T[] arrayFilled(@NotNull T[] array) {
        if (array == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        for (int i = array.length - 1; i >= 0; --i) {
            if (array[i] != null) continue;
            throw new IllegalArgumentException("array contains null at " + i + "; length=" + array.length);
        }
        if (array == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return array;
    }

    public static void fail() {
        throw new IllegalStateException("assertion failed");
    }

    public static void assertEqual(int a, int b) {
        if (a != b) {
            throw new IllegalArgumentException("assertion failed: " + a + " != " + b);
        }
    }

    public static void assertEqual(long a, long b) {
        if (a != b) {
            throw new IllegalArgumentException("assertion failed: " + a + " != " + b);
        }
    }

    public static void assertEqual(double a, double b) {
        if (a != b) {
            throw new IllegalArgumentException("assertion failed: " + a + " != " + b);
        }
    }

    public static void assertEqual(float a, float b) {
        if (a != b) {
            throw new IllegalArgumentException("assertion failed: " + a + " != " + b);
        }
    }

    public static void assertEqual(boolean a, boolean b) {
        if (a != b) {
            throw new IllegalArgumentException("assertion failed: " + a + " != " + b);
        }
    }

    public static void assertEqual(@Nullable Object a, @Nullable Object b) {
        if (!Objects.equals(a, b)) {
            throw new IllegalArgumentException("assertion failed: " + a + " != " + b);
        }
    }

    public static void assertNull(Object o) throws IllegalArgumentException {
        if (o != null) {
            throw new IllegalArgumentException("assertion failed; " + o);
        }
    }

    public static void assertFalse(boolean b) throws IllegalArgumentException {
        if (b) {
            throw new IllegalArgumentException();
        }
    }

    public static void assertTrue(boolean b) throws IllegalArgumentException {
        if (!b) {
            throw new IllegalArgumentException();
        }
    }

    public static void assertTrue(boolean b, @NotNull String message) throws IllegalArgumentException {
        if (message == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (!b) {
            throw new IllegalArgumentException(message);
        }
    }

    public static int requirePositive(int v) throws IllegalArgumentException {
        if (v < 0) {
            throw new IllegalArgumentException("v=" + v);
        }
        return v;
    }

    public static long requirePositive(long v) throws IllegalArgumentException {
        if (v < 0L) {
            throw new IllegalArgumentException("v=" + v);
        }
        return v;
    }

    public static void assertEdt() {
        if (!ourHeadless && !EventQueue.isDispatchThread()) {
            Asserts.fail();
        }
    }

    public static void assertNotEdt() {
        if (!ourHeadless && EventQueue.isDispatchThread()) {
            Asserts.fail();
        }
    }

    public static boolean isHeadless() {
        return ourHeadless;
    }

    public static void setHeadless(boolean headless) {
        ourHeadless = headless;
    }
}

