/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit;

import com.yourkit.asserts.NotNull;
import com.yourkit.util.JavaVersion;
import com.yourkit.util.Os;
import com.yourkit.util.Properties;
import com.yourkit.util.Strings;
import java.io.File;

public final class Constants {
    public static final boolean Y_YNP = false;
    public static final boolean Y_YM = false;
    public static final boolean Y_YJS = false;
    public static final boolean Y_YCB = false;
    public static final boolean Y_YJP = true;
    public static final boolean EAP = false;
    public static final String SNAPSHOT_FILE_EXTENSION = ".snapshot";
    public static final String HPROF_FILE_EXTENSION = ".hprof";
    public static final String PHD_FILE_EXTENSION = ".phd";
    public static final String JFR_FILE_EXTENSION = ".jfr";
    public static final String JS_SNAPSHOT_FILE_EXTENSION = ".heapsnapshot";
    public static final String LOG_FILE_EXTENSION = ".log";
    public static final File USER_HOME_RAW = new File(Properties.user_home.valueNotNull());
    public static final File USER_HOME;
    public static final boolean CUSTOM_USER_HOME;
    public static final File SNAPSHOT_DIR;
    public static final File APP_SETTINGS_DIR;
    @NotNull
    public static final File PREFERRED_SNAPSHOT_DIR_FILE;
    @NotNull
    public static final File YM_REPOSITORIES_DIR;
    @NotNull
    public static final String OS;
    public static final boolean OS_LINUX;
    public static final boolean OS_MAC;
    public static final boolean OS_WINDOWS;
    @NotNull
    public static final String JAVA_VERSION;
    public static final int JAVA_VERSION_NUMBER;
    @NotNull
    public static final String LINE_SEPARATOR;
    @NotNull
    public static final String APP_SHORT_NAME = "YourKit Java Profiler";
    @NotNull
    public static final String APP_RELEASE_NAME = "YourKit Java Profiler 2025.3";
    public static final String APP_FULL_NAME = "YourKit Java Profiler 2025.3-b154";
    public static final String MESSAGE_DLG_TITLE = "YourKit Java Profiler 2025.3-b154";
    public static final String ERROR_DLG_TITLE = "Error - YourKit Java Profiler 2025.3-b154";
    public static final String WARNING_DLG_TITLE = "Warning - YourKit Java Profiler 2025.3-b154";
    public static final String INTERNAL_ERROR_DLG_TITLE = "Internal Error - YourKit Java Profiler 2025.3-b154";
    public static final int DEFAULT_PORT_MIN = 10001;
    public static final int DEFAULT_PORT_MAX = 10010;
    public static final String DEFAULT_PORTS = "10001-10010";
    public static final String NATIVE_METHOD_PREFIX = "$$YJP$$";
    public static final String BUILD_TIME_STAMP = "202508131459";
    public static final long SNAPSHOT_WITH_HEAP = 1L;
    public static final long SNAPSHOT_WITH_CPU_TRACING_RESULTS = 8L;
    public static final long SNAPSHOT_HPROF = 16L;
    public static final long SNAPSHOT_ON_SHUTDOWN = 32L;
    public static final long SNAPSHOT_OIDS_ARE_INDICES = 512L;
    public static final long SNAPSHOT_ON_EVENT = 4096L;
    public static final long SNAPSHOT_EXTRACTED_PERFORMANCE = 8192L;
    public static final long SNAPSHOT_AGENT_ATTACHED = 16384L;
    public static final long SNAPSHOT_AGENT_LOADED_ON_START = 32768L;
    public static final String AGENT_THREAD_PREFIX = "YJPAgent-";
    public static final int COLUMN_TYPE_INT = 0;
    public static final int COLUMN_TYPE_LONG = 1;
    public static final int COLUMN_TYPE_STRING = 2;
    public static final int COLUMN_TYPE_FOREIGN_KEY = 3;
    public static final int COLUMN_TYPE_CLASS_NAME = 4;
    public static final int COLUMN_TYPE_OBJECT = 5;
    public static final String EVENT_TABLE_PREDEFINED_COLUMN_UPTIME_NS = "uptime_ns";
    public static final String EVENT_TABLE_PREDEFINED_COLUMN_UPTIME_NS_END = "uptime_ns.end";
    public static final String EVENT_TABLE_PREDEFINED_COLUMN_EXCEPTION_STR = "exception_str";
    public static final String EVENT_TABLE_PREDEFINED_COLUMN_THREAD = "thread";
    public static final String EVENT_TABLE_PREDEFINED_COLUMN_STACKTRACE = "frame";
    public static final String EVENT_TABLE_PREDEFINED_COLUMN_RESOURCE_OBJECT_ID = "resource_object_id";
    public static final String EVENT_TABLE_PREDEFINED_COLUMN_RESOURCE_OBJECT_CLASS = "Class";
    public static final long NANOS_PER_SEC = 1000000000L;
    public static final long NANOS_PER_MILLISECOND = 1000000L;
    public static final long NANOS_PER_MICROSECOND = 1000L;
    public static final long MS_PER_DS = 100L;
    public static final int BYTES_IN_MB = 0x100000;
    public static final int UNDEFINED_LINE = 0;
    public static final String LISTEN_ALL = "all";
    public static final String LISTEN_LOCALHOST = "localhost";
    public static final boolean IS_IBM;
    public static final int MIN_SUPPORTED_JDK_VERSION = 8;
    public static final int MAX_SUPPORTED_JDK_VERSION = 24;

    @NotNull
    public static File getAppHome(@NotNull File userHome) {
        if (userHome == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String appHome = ".yjp";
        return new File(userHome, appHome);
    }

    static {
        String path = null;
        try {
            path = System.getenv("YOURKIT_HOME");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        boolean bl = CUSTOM_USER_HOME = !Strings.isNullOrEmpty(path);
        if (!CUSTOM_USER_HOME) {
            path = Properties.user_home.valueNotNull();
        }
        USER_HOME = new File(path);
        SNAPSHOT_DIR = OS_WINDOWS || CUSTOM_USER_HOME || USER_HOME.isDirectory() && USER_HOME.canWrite() ? new File(USER_HOME, "Snapshots") : new File("/tmp");
        APP_SETTINGS_DIR = Constants.getAppHome(USER_HOME);
        PREFERRED_SNAPSHOT_DIR_FILE = new File(APP_SETTINGS_DIR, "snapshotdir.txt");
        YM_REPOSITORIES_DIR = new File(APP_SETTINGS_DIR, "repositories");
        OS = Properties.os_name.valueNotNull();
        OS_LINUX = Os.getCurrent().isLinux();
        OS_MAC = Os.getCurrent().isMac();
        OS_WINDOWS = Os.getCurrent().isWindows();
        JAVA_VERSION = Properties.java_version.valueNotNull();
        JAVA_VERSION_NUMBER = JavaVersion.getJavaVersion(JAVA_VERSION);
        LINE_SEPARATOR = OS_WINDOWS ? "\r\n" : "\n";
        String vmVendor = Properties.java_vm_vendor.value("");
        IS_IBM = vmVendor.contains("IBM") || vmVendor.contains("OpenJ9");
    }
}

